<?php defined('SYSPATH') or die('No direct script access.');

class Task_Search_Logpost extends Minion_Task {
	protected function _execute(array $params){
		Task_Helper::createWorker('Search::Logpost', $this);
	}

	public function Worker(GearmanJob $job){
		$workload = json_decode($job->workload(), true);
		$client = $workload['client'];
		$tor = $workload['tor'];

		$sphinxql = new SphinxQL();

		$data = Model::factory('Client')->getClientInfo($client);
		if(!empty($data)){
			$logpost = $sphinxql->new_query()
				->add_field('id')
				->add_field('link')
				->add_field('datetime')
				->add_index('logpost')
				->where('client_id', (string)$data['id'], '=')
				->order('datetime', 'desc')
				->limit(1000000)
				->option('max_matches', '1000000')
				->execute();

			if($tor)
				$logpost['server'] = Kohana::$config->load('init.local_info.tor');
			else
				$logpost['server'] = Kohana::$config->load('init.local_info.ip');

			$logpost['client'] = [
				'version' => $data['version'],
				'name' => $data['prefix'].'.'.$data['client']
			];

			return json_encode($logpost);
		}

		return false;
	}
}